#ifndef CVRSDK_H
#define CVRSDK_H

#ifdef BUILD_CVRSDK_DLL

#define CVRSDK_EXT_API __declspec(dllexport)

#else

#define CVRSDK_EXT_API __declspec(dllimport)

#endif

#ifdef _VBEXPORT // "DUMPBIN.EXE /EXPORTS CVRSDK.DLL >> EXPORTS.TXT"

#ifdef CVRSDK_EXPORTS

#define CVRSDK_EXPORT __stdcall

#else

#define CVRSDK_EXPORT __stdcall

#endif

#else 

#ifdef CVRSDK_EXPORTS

#define CVRSDK_EXPORT __cdecl

#else

#define CVRSDK_EXPORT __cdecl

#endif

#endif

enum {

	CVRSDK_PRESENT_INTERVAL_DEFAULT   = 0x00000000,
	CVRSDK_PRESENT_INTERVAL_ONE       = 0x00000001,
	CVRSDK_PRESENT_INTERVAL_TWO       = 0x00000002,
	CVRSDK_PRESENT_INTERVAL_THREE     = 0x00000004,
	CVRSDK_PRESENT_INTERVAL_FOUR      = 0x00000008,
	CVRSDK_PRESENT_INTERVAL_IMMEDIATE = 0x80000000,
};

// ##########################################################################################################################################################################################
// #
// # VIDEO RENDERER FUNCTIONS
// #
// ##########################################################################################################################################################################################
// 
CVRSDK_EXT_API PVOID CVRSDK_EXPORT CVRSDK_CREATE();

CVRSDK_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_DESTROY( PVOID pVideoRenderer /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # CHANNEL WINDOW FUNCTIONS
// #
// ##########################################################################################################################################################################################
// 
CVRSDK_EXT_API PVOID CVRSDK_EXPORT CVRSDK_INSERT_CHANNEL_WINDOW( PVOID pVideoRenderer /*IN*/, HWND hDisplayWindow /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/, DWORD dwBackgroundColor = 0x00000000 /*IN*/, ULONG dwPresentationInterval = CVRSDK_PRESENT_INTERVAL_IMMEDIATE /*IN*/ );

CVRSDK_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_REMOVE_CHANNEL_WINDOW( PVOID pVideoRenderer /*IN*/, PVOID pChannelWindow /*IN*/ );

CVRSDK_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_RESIZE_CHANNEL_WINDOW( PVOID pChannelWindow /*IN*/ );

CVRSDK_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_UPDATE_VIDEO_BUFFER( PVOID pChannelWindow /*IN*/, ULONG nVideoColorSpaceType /*IN*/, BYTE * pVideoFrameBuffer /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/, ULONG nVideoPitch /*IN*/, BOOL bVideoIsInterleaved /*IN*/ );

CVRSDK_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_SNAPSHOT_BMP( PVOID pChannelWindow /*IN*/, CHAR * pszFilePathName /*IN*/ );

CVRSDK_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_SNAPSHOT_JPG( PVOID pChannelWindow /*IN*/, CHAR * pszFilePathName /*IN*/ );

// ##########################################################################################################################################################################################
// #
// # OVERLAY FUNCTIONS
// #
// ##########################################################################################################################################################################################
// 
CVRSDK_EXT_API PVOID CVRSDK_EXPORT CVRSDK_CREATE_OVERLAY_BUFFER( PVOID pChannelWindow /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/ );

CVRSDK_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_DESTROY_OVERLAY_BUFFER( PVOID pChannelWindow /*IN*/, PVOID pOverlayWindow /*IN*/ );

CVRSDK_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_LOCK_OVERLAY_BUFFER( PVOID pChannelWindow /*IN*/, PVOID pOverlayWindow /*IN*/, HDC * pMemoryDC /*OUT*/ );

CVRSDK_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_UNLOCK_OVERLAY_BUFFER( PVOID pChannelWindow /*IN*/, PVOID pOverlayWindow /*IN*/, HDC hMemoryDC /*IN*/ );

CVRSDK_EXT_API BOOL  CVRSDK_EXPORT CVRSDK_SHOW_OVERLAY_BUFFER( PVOID pChannelWindow /*IN*/, PVOID pOverlayWindow /*IN*/, BOOL bShowOverlay /*IN*/, ULONG nPositionX /*IN*/, ULONG nPositionY /*IN*/ );

#endif